%------------------------------------------------------------------------------
% File     : NLP267^17 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Natural Language Processing
% Problem  : Ticket example
% Version  : [BP13] axioms.
% English  : 

% Refs     : [FH+98] Farinas del Cerro et al. (1998), Belief Reconstruction
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : MML016+1 [QMLTP]

% Status   : Theorem 
% Rating   : 0.22 v9.1.0, 0.25 v9.0.0, 0.20 v8.2.0, 0.31 v8.1.0
% Syntax   : Number of formulae    :   42 (  10 unt;  22 typ;   8 def)
%            Number of atoms       :   72 (   8 equ;   0 cnn)
%            Maximal formula atoms :    7 (   3 avg)
%            Number of connectives :  116 (   1   ~;   1   |;   4   &; 105   @)
%                                         (   1 <=>;   4  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   5 avg)
%            Number of types       :    4 (   2 usr)
%            Number of type conns  :   54 (  54   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   21 (  20 usr;   8 con; 0-3 aty)
%            Number of variables   :   31 (  21   ^;   9   !;   1   ?;  31   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $cumulative,
%            $modalities == $modal_system_S5].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mindex,type,
    mindex: $tType ).

thf(mrel_type,type,
    mrel: mindex > mworld > mworld > $o ).

thf('#b_u_type',type,
    '#b_u': mindex ).

thf('#b_s_type',type,
    '#b_s': mindex ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: mindex > ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [R: mindex,Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ R @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: mindex > ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [R: mindex,Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ R @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf('mrel_#b_u_reflexive',axiom,
    ! [W: mworld] : ( mrel @ '#b_u' @ W @ W ) ).

thf('mrel_#b_u_euclidean',axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ '#b_u' @ W @ U )
        & ( mrel @ '#b_u' @ W @ V ) )
     => ( mrel @ '#b_u' @ U @ V ) ) ).

thf('mrel_#b_s_reflexive',axiom,
    ! [W: mworld] : ( mrel @ '#b_s' @ W @ W ) ).

thf('mrel_#b_s_euclidean',axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ '#b_s' @ W @ U )
        & ( mrel @ '#b_s' @ W @ V ) )
     => ( mrel @ '#b_s' @ U @ V ) ) ).

thf(seventy_decl,type,
    seventy: $i ).

thf(ninetyfive_decl,type,
    ninetyfive: $i ).

thf(second_decl,type,
    second: $i ).

thf(paris_decl,type,
    paris: $i ).

thf(first_decl,type,
    first: $i ).

thf(price_decl,type,
    price: $i > mworld > $o ).

thf(dest_decl,type,
    dest: $i > mworld > $o ).

thf(class_decl,type,
    class: $i > mworld > $o ).

thf(axiom_1,axiom,
    mlocal @ ( mbox @ '#b_s' @ ( mimplies @ ( mand @ ( dest @ paris ) @ ( class @ first ) ) @ ( price @ ninetyfive ) ) ) ).

thf(axiom_2,axiom,
    mlocal @ ( mbox @ '#b_s' @ ( mimplies @ ( mand @ ( dest @ paris ) @ ( class @ second ) ) @ ( price @ seventy ) ) ) ).

thf(axiom_3_s,axiom,
    mlocal @ ( mbox @ '#b_s' @ ( mnot @ ( mand @ ( class @ first ) @ ( class @ second ) ) ) ) ).

thf(axiom_3_u,axiom,
    mlocal @ ( mbox @ '#b_u' @ ( mnot @ ( mand @ ( class @ first ) @ ( class @ second ) ) ) ) ).

thf(axiom_4_s,axiom,
    mlocal @ ( mbox @ '#b_s' @ ( mnot @ ( mand @ ( price @ seventy ) @ ( price @ ninetyfive ) ) ) ) ).

thf(axiom_4_u,axiom,
    mlocal @ ( mbox @ '#b_u' @ ( mnot @ ( mand @ ( price @ seventy ) @ ( price @ ninetyfive ) ) ) ) ).

thf(axiom_5,axiom,
    mlocal @ ( mbox @ '#b_s' @ ( mand @ ( dest @ paris ) @ ( class @ second ) ) ) ).

thf(con,conjecture,
    mlocal @ ( mbox @ '#b_s' @ ( price @ seventy ) ) ).

%------------------------------------------------------------------------------
